#!/bin/bash

if [ -x /usr/bin/p81-helper-daemon-creator ]; then
  sudo /usr/bin/p81-helper-daemon-creator stop /usr/bin/p81-helper-daemon
  sudo /usr/bin/p81-helper-daemon-creator uninstall /usr/bin/p81-helper-daemon
fi

sudo rm /usr/bin/p81-helper-daemon
sudo rm /usr/bin/p81-helper-daemon-creator

if [ -d "/opt/Perimeter81" ]
then
  sudo cp /opt/Perimeter81/artifacts/daemon /usr/bin/p81-helper-daemon
  sudo cp /opt/Perimeter81/artifacts/daemon-creator /usr/bin/p81-helper-daemon-creator
  sudo chmod 4755 /opt/Perimeter81/chrome-sandbox

  if [ ! -f "/usr/share/applications/perimeter81.desktop" ]
  then
    echo "[Desktop Entry]" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Name=Perimeter81" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Exec=/opt/Perimeter81/perimeter81 %U" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Terminal=false" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Type=Application" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Icon=perimeter81" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "StartupWMClass=Perimeter81" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Comment=Perimeter81 Linux agent" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "MimeType=x-scheme-handler/com.perimeter81.linux;" | sudo tee -a /usr/share/applications/perimeter81.desktop
    echo "Categories=network;" | sudo tee -a /usr/share/applications/perimeter81.desktop
  fi
fi

if [ -d "/opt/SonicWall" ]
then
  sudo cp /opt/SonicWall/artifacts/daemon /usr/bin/p81-helper-daemon
  sudo cp /opt/SonicWall/artifacts/daemon-creator /usr/bin/p81-helper-daemon-creator
  sudo chmod 4755 /opt/SonicWall/chrome-sandbox

  if [ ! -f "/usr/share/applications/sonicwall.desktop" ]
  then
    echo "[Desktop Entry]" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Name=SonicWall" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Exec=/opt/SonicWall/sonicwall %U" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Terminal=false" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Type=Application" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Icon=sonicwall" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "StartupWMClass=SonicWall" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Comment=Perimeter81 Linux agent" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "MimeType=com.sonicwall.edge.linux;" | sudo tee -a /usr/share/applications/sonicwall.desktop
    echo "Categories=network;" | sudo tee -a /usr/share/applications/sonicwall.desktop
  fi
fi

if /usr/bin/grep -q "perimeter81.desktop" /home/*/.config/mimeapps.list
then
  echo "We detected that Perimeter81's agent mime type association is removed. Cleaning up ~/.config/mimeapps.list file."
  /usr/bin/sed -i '/perimeter81.desktop/d' /home/*/.config/mimeapps.list
fi

sudo /usr/bin/p81-helper-daemon-creator uninstall /usr/bin/p81-helper-daemon
sudo /usr/bin/p81-helper-daemon-creator install /usr/bin/p81-helper-daemon

sudo systemctl enable perimeter81helper

sudo rm -rf /etc/sudoers.d/perimeter81

echo "Appending daemon rules to /etc/sudoers.d/perimeter81..."

echo "# Perimeter81 Start" | sudo tee -a /etc/sudoers.d/perimeter81
echo "ALL ALL=NOPASSWD: /usr/bin/p81-helper-daemon" | sudo tee -a /etc/sudoers.d/perimeter81
echo "ALL ALL=NOPASSWD: /usr/bin/p81-helper-daemon-creator" | sudo tee -a /etc/sudoers.d/perimeter81
echo "# Perimeter81 End" | sudo tee -a /etc/sudoers.d/perimeter81

sudo chmod 0440 /etc/sudoers.d/perimeter81

echo "Done appending daemon rules to /etc/sudoers.d/perimeter81."

sudo rm -rf /usr/lib/systemd/system-sleep/perimeter81

echo "Appending sleep/awake detection to /usr/lib/systemd/system-sleep/perimeter81..."

echo "#!/bin/sh" | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81
echo 'case $1/$2 in' | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81
echo '  post/*)' | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81
echo '    /usr/bin/p81-helper-daemon-creator system-resume' | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81
echo '    ;;' | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81
echo '  pre/*)' | sudo tee -a /lib/systemd/system-sleep/perimeter81
echo '    /usr/bin/p81-helper-daemon-creator system-sleep' | sudo tee -a /lib/systemd/system-sleep/perimeter81
echo '    ;;' | sudo tee -a /lib/systemd/system-sleep/perimeter81
echo 'esac' | sudo tee -a /usr/lib/systemd/system-sleep/perimeter81

sudo chmod a+x /usr/lib/systemd/system-sleep/perimeter81

echo "Done appending sleep/awake detection to /usr/lib/systemd/system-sleep/perimeter81..."

echo "Appending network status detection to /etc/NetworkManager/dispatcher.d/50-perimeter81..."

sudo rm /etc/NetworkManager/dispatcher.d/50-perimeter81

echo "#!/bin/bash -e" | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'if [[ $1 == "tun0" ]]; then ' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '  exit 0' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'fi' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'if [[ $1 == "ipsec0" ]]; then ' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '  exit 0' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'fi' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'if [[ $1 == "p81" ]]; then ' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '  exit 0' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'fi' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'logger -s "P81 INTERFACE $1 $2"' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'case "$2" in' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '  up)' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '    /usr/bin/p81-helper-daemon-creator network-interface-up' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '    ;;' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '  down)' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '    /usr/bin/p81-helper-daemon-creator network-interface-down' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo '    ;;' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81
echo 'esac' | sudo tee -a /etc/NetworkManager/dispatcher.d/50-perimeter81

sudo chmod a+x /etc/NetworkManager/dispatcher.d/50-perimeter81

echo "Done appending network status detection to /etc/NetworkManager/dispatcher.d/50-perimeter81..."

SSL_VER=$(openssl version)
SSL_EXIST=$(command -v openssl)
if [ -z "${SSL_VER}" ] || [ -z "${SSL_EXIST}" ] ; then
  echo "openssl installation needs to be validated manually by the user"
fi

if [ ! -f "/etc/fedora-release" ]
then
  echo "Installing kmod-wireguard..."
  mkdir -p /etc/depmod.d
  rm -rf /etc/depmod.d/kmod-wireguard.conf
  touch /etc/depmod.d/kmod-wireguard.conf

  echo 'override wireguard * weak-updates/wireguard' | sudo tee -a /etc/depmod.d/kmod-wireguard.conf

  sudo mkdir -p /lib/modules/3.10.0-1160.el7.x86_64/extra/wireguard
  sudo mkdir -p /lib/modules/4.18.0-240.el8.x86_64/extra/wireguard
  sudo mkdir -p /lib/modules/4.18.0-305.el8.x86_64/extra/wireguard
  sudo mkdir -p /lib/modules/4.18.0-348.el8.x86_64/extra/wireguard

  if [ -d "/opt/Perimeter81" ]
  then
    sudo cp /opt/Perimeter81/upstream/3.10.0-1160.el7.x86_64/extra/wireguard/wireguard.ko /lib/modules/3.10.0-1160.el7.x86_64/extra/wireguard
    sudo cp /opt/Perimeter81/upstream/4.18.0-240.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-240.el8.x86_64/extra/wireguard
    sudo cp /opt/Perimeter81/upstream/4.18.0-305.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-305.el8.x86_64/extra/wireguard
    sudo cp /opt/Perimeter81/upstream/4.18.0-348.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-348.el8.x86_64/extra/wireguard
  fi

  if [ -d "/opt/SonicWall" ]
  then
    sudo cp /opt/SonicWall/upstream/3.10.0-1160.el7.x86_64/extra/wireguard/wireguard.ko /lib/modules/3.10.0-1160.el7.x86_64/extra/wireguard
    sudo cp /opt/SonicWall/upstream/4.18.0-240.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-240.el8.x86_64/extra/wireguard
    sudo cp /opt/SonicWall/upstream/4.18.0-305.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-305.el8.x86_64/extra/wireguard
    sudo cp /opt/SonicWall/upstream/4.18.0-348.el8.x86_64/extra/wireguard/wireguard.ko /lib/modules/4.18.0-348.el8.x86_64/extra/wireguard
  fi

  modules=( $(find /lib/modules/3.10.0-1160.el7.x86_64/extra/wireguard | grep '\.ko$') )
  printf '%s\n' "${modules[@]}" | sudo /usr/sbin/weak-modules --add-modules --no-initramfs

  modules=( $(find /lib/modules/4.18.0-240.el8.x86_64/extra/wireguard | grep '\.ko$') )
  printf '%s\n' "${modules[@]}" | sudo /usr/sbin/weak-modules --add-modules --no-initramfs

  modules=( $(find /lib/modules/4.18.0-305.el8.x86_64/extra/wireguard | grep '\.ko$') )
  printf '%s\n' "${modules[@]}" | sudo /usr/sbin/weak-modules --add-modules --no-initramfs

  modules=( $(find /lib/modules/4.18.0-348.el8.x86_64/extra/wireguard | grep '\.ko$') )
  printf '%s\n' "${modules[@]}" | sudo /usr/sbin/weak-modules --add-modules --no-initramfs

  sudo mkdir -p "/var/lib/rpm-state/kmod-dups/kver"

  sudo touch "/var/lib/rpm-state/kmod-dups/kver/3.10.0-1160.el7.x86_64"
  sudo touch "/var/lib/rpm-state/kmod-dups/kver/4.18.0-240.el8.x86_64"
  sudo touch "/var/lib/rpm-state/kmod-dups/kver/4.18.0-305.el8.x86_64"
  sudo touch "/var/lib/rpm-state/kmod-dups/kver/4.18.0-348.el8.x86_64"

  echo "Done installing kmod-wireguard..."
fi

