sudo /usr/bin/p81-helper-daemon-creator pre-uninstall-actions

if [ -x /usr/bin/p81-helper-daemon-creator ]; then
  sudo /usr/bin/p81-helper-daemon-creator stop /usr/bin/p81-helper-daemon
  sudo /usr/bin/p81-helper-daemon-creator uninstall /usr/bin/p81-helper-daemon
fi

if rpm -q --filetriggers kmod 2> /dev/null| grep -q "Trigger for weak-modules call on kmod removal"; then
  initramfs_opt="--no-initramfs"
else
  initramfs_opt=""
fi

SSL_VER=$(openssl version)
SSL_EXIST=$(command -v openssl)
if [ -z "${SSL_VER}" ] || [ -z "${SSL_EXIST}" ] ; then
  echo "openssl installation needs to be validated manually by the user"
fi

if [ ! -f "/etc/fedora-release" ]
then
  modules=( $(cat "/var/lib/rpm-state/kmod-dups/rpm-kmod-wireguard-modules") )
  rm -f "/var/lib/rpm-state/kmod-dups/rpm-kmod-wireguard-modules"
  printf '%s\n' "${modules[@]}" | sudo /usr/sbin/weak-modules --remove-modules $initramfs_opt

  rmdir "/var/lib/rpm-state/kmod-dups" 2> /dev/null
fi

sudo rm /usr/bin/p81-helper-daemon
sudo rm /usr/bin/p81-helper-daemon-creator

sudo rm -rf /etc/sudoers.d/perimeter81
sudo rm -rf /usr/lib/systemd/system-sleep/perimeter81
sudo rm -rf /etc/NetworkManager/dispatcher.d/50-perimeter81
sudo rm -rf /usr/share/applications/perimeter81.desktop
sudo rm -rf /etc/Perimeter81
sudo rm -rf /var/log/perimeter81helper*

sudo rm -rf /opt/Perimeter81
sudo rm /var/lib/dpkg/info/perimeter81*
sudo rm /etc/systemd/system/multi-user.target.wants/perimeter81helper.service

sudo rm /run/user/1000/systemd/units/invocation:app-gnome-perimeter81*
sudo rm /run/user/1000/systemd/transient/app-gnome-perimeter81*
sudo rm /sys/fs/cgroup/user.slice/user-1000.slice/user@1000.service/app.slice/app-gnome-perimeter81*
sudo rm -rf /usr/local/share/ca-certificates/perimeter81
sudo rm /etc/ssl/certs/perimeter81*
sudo rm /run/user/1000/systemd/generator.late/app-perimeter81*

for user in "/home"/*; do
  if [ -d "$user" ]; then
    if [ -d "$user"/.config/Perimeter81 ]; then
      sudo rm -rf "$user"/.config/Perimeter81
    fi

    if [ -d "$user/.config/Harmony SASE" ]; then
      sudo rm -rf "$user/.config/Harmony SASE"
    fi

    if [ -d "$user"/.config/autostart ]; then
      sudo rm "$user"/.config/autostart/perimeter81.desktop
    fi
  fi
done

# Ensure the script exits successfully
exit 0
